#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z 1.f
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static float Matrix[16];
static float Matrix2[16];
static float Gouraud[16];
static float Gouraud2[16];

static Obj3d *pEarth;

void LInit_Earth()
{
	//pEarth = GenerateSphere(25, 25, 800, 800, 256, 256);
	pEarth = GenerateSphere(40, 25, 800, 800, 256, 256);
	ComputeGouraud(pEarth);
	//LoadJpegTexture(earth, &g_TextureEarth);
	PrepareTextureFromArray(g_PicEarth, 256, 256, &g_TextureEarth);
	PrepareTextureFromArray(g_PicDolby, 256, 256, &g_TextureDolby);
}

void QInit_Earth()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grConstantColorValue(192<<24);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grCullMode(GR_CULL_POSITIVE);
	grFogMode(GR_FOG_DISABLE);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);

	DownloadTexture(&g_TextureEarth);
	DownloadTexture(&g_TextureDolby);

	SelectTexture(g_TextureEarth);

	BeIdentityMatrix(Gouraud);
}

void Effect_Earth()
{
	float Img1 = g_demostate.TickInEffect/15.f;
	float fSinTmp, fCosTmp;
	//DWORD dwTmp = g_demostate.TickInEffect*0.8f;

	grCullMode(GR_CULL_DISABLE);
	grDepthMask(FALSE);
	SelectTexture(g_TextureDolby);
	fSinTmp = 10.f*SinTable[(g_demostate.TickInEffect*8)&8191]+10.f;
	fCosTmp = 10.f*CosTable[(g_demostate.TickInEffect*8)&8191]+10.f;
	Fond1.x = 0.f+g_demostate.TickInEffect*640/8192/8+fSinTmp;
	Fond1.y = 0.f+g_demostate.TickInEffect*480/8192/8+fCosTmp;
	Fond2.x = 640.f-g_demostate.TickInEffect*640/8192/8-fSinTmp;
	Fond2.y = 0.f+g_demostate.TickInEffect*480/8192/8+fCosTmp;
	Fond3.x = 640.f-g_demostate.TickInEffect*640/8192/8-fSinTmp;
	Fond3.y = 480.f-g_demostate.TickInEffect*480/8192/8-fCosTmp;
	Fond4.x = 0.f+g_demostate.TickInEffect*640/8192/8+fSinTmp;
	Fond4.y = 480.f-g_demostate.TickInEffect*480/8192/8-fCosTmp;
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
	grDepthMask(TRUE);
	grCullMode(GR_CULL_POSITIVE);

	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*2); // 1/70
	//RotateYMatrix(Matrix2, Matrix, Img1/50.f);
	TranslateMatrix(Matrix2, 6000.f/(float)sqrt(2), 0, 6000.f/(float)sqrt(2));
	RotateYMatrix(Matrix, Matrix2, -g_demostate.TickInEffect); // -1/140
	TranslateMatrix(Matrix, 5000, 0, 0);

	RotateYMatrix(Gouraud2, Gouraud, (DWORD)(g_demostate.TickInEffect*1.5f)); // Img1/75.f+4.5f

	SelectTexture(g_TextureEarth);
	DrawWithMatrix(pEarth, Matrix, true, Gouraud2, 0);
}

void ByeBye_Earth()
{
	FreeTexture(&g_TextureEarth);
	FreeTexture(&g_TextureDolby);
}